/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.eventlog;

import filenet.pa.datacollector.PEEventLog;
import filenet.pa.sql.PAPEPartition;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogBaseNode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogNode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogRegionNode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogRootNode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogTree;
import filenet.vw.apps.taskman.pa.eventlog.EventLogTreeCellEditor;
import filenet.vw.apps.taskman.pa.eventlog.EventLogTreeCellRenderer;
import filenet.vw.apps.taskman.pa.panonrmi.IPANonRMI;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class EventLogConfigPanel
extends VWTaskTabPanel {
    private PANode m_node = null;
    private EventLogTree m_tree = null;
    private EventLogRootNode m_root = null;
    private boolean m_layoutInitialized = false;
    private HashMap m_committedPartitions = new HashMap();
    private final String m_className = EventLogConfigPanel.class.getName();
    private Logger m_logger = Logger.getLogger("filenet.vw.apps.taskman");

    public EventLogConfigPanel(PANode node) {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.m_node = node;
        this.m_root = new EventLogRootNode(this);
        this.m_tree = new EventLogTree(new DefaultTreeModel(this.m_root));
        this.m_tree.setEditable(true);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setCellRenderer(new EventLogTreeCellRenderer(this, this.m_tree));
        this.m_tree.setCellEditor(new EventLogTreeCellEditor());
        VWTaskUtil.updateComponentOrientation(this.m_tree);
    }

    public boolean applyProperties() throws Exception {
        PAPEPartition[][] partitions = this.getUpdatedPartitions();
        PAPEPartition[] selected = partitions[0];
        Object[] deSelected = partitions[1];
        this.logPartitionArray(selected, "Selected Partitions");
        this.logPartitionArray((PAPEPartition[])deSelected, "Deselected Partitions");
        if (deSelected.length > 0) {
            Arrays.sort(deSelected);
            boolean displayMsg = false;
            StringBuffer b = new StringBuffer();
            int region = -1;
            for (int i = 0; i < deSelected.length; ++i) {
                Object p = deSelected[i];
                EventLogRegionNode regionNode = this.m_root.getRegionNode(p.getRegionId());
                EventLogNode logNode = regionNode.getEventLogNode(p.getEventLog());
                if (logNode.isAllEventLog()) {
                    Enumeration<TreeNode> j = regionNode.children();
                    while (j.hasMoreElements()) {
                        EventLogNode siblingLog = (EventLogNode)j.nextElement();
                        if (siblingLog.isAllEventLog() || siblingLog.isSelected()) continue;
                        if (p.getRegionId() != region) {
                            region = p.getRegionId();
                            b.append("\n" + VWResource.RegionNumber.toString(new Integer(p.getRegionId())));
                        }
                        b.append("\n    " + siblingLog.getName());
                        displayMsg = true;
                    }
                    continue;
                }
                if (Arrays.binarySearch(deSelected, regionNode.getAllEventLogNode().getPartition()) >= 0) continue;
                if (p.getRegionId() != region) {
                    region = p.getRegionId();
                    b.append("\n" + VWResource.RegionNumber.toString(new Integer(p.getRegionId())));
                }
                b.append("\n    " + logNode.getName());
                displayMsg = true;
            }
            if (displayMsg) {
                VWString msg = new VWString("filenet.vw.apps.taskman.pa.eventlog.EventLogConfigPanel.LogDeselectionConfirmation", "Are you sure that you want to stop processing events from the following event logs?\n{0}");
                if (!VWTaskCore.getInstance().displayConfirmation(msg.toString(b.toString()), 3, this.m_node.getHelpPath("EventLogConfigPanel.htm"), 500, 300)) {
                    return false;
                }
            }
        }
        IPANonRMI paNonRMI = this.m_node.getPANonRMI();
        paNonRMI.updatePAPEPartitions(selected, (PAPEPartition[])deSelected);
        this.setCommittedPartitions(paNonRMI.getPAPEPartitions());
        return true;
    }

    public PAPEPartition[][] getUpdatedPartitions() {
        ArrayList<PAPEPartition> selected = new ArrayList<PAPEPartition>();
        ArrayList<PAPEPartition> deSelected = new ArrayList<PAPEPartition>();
        Enumeration<TreeNode> i = this.m_root.depthFirstEnumeration();
        while (i.hasMoreElements()) {
            EventLogBaseNode node = (EventLogBaseNode)i.nextElement();
            if (!(node instanceof EventLogNode)) continue;
            EventLogRegionNode region = (EventLogRegionNode)node.getParent();
            EventLogNode log = (EventLogNode)node;
            boolean selectedOnPA = this.isPartitionCommitted(log.getPartition());
            if (log.isSelected()) {
                if (selectedOnPA || !log.isAllEventLog() && region.getAllEventLogNode().isSelected()) continue;
                selected.add(log.getPartition());
                continue;
            }
            if (!selectedOnPA) continue;
            deSelected.add(log.getPartition());
        }
        PAPEPartition[][] partitions = new PAPEPartition[][]{selected.toArray(new PAPEPartition[0]), deSelected.toArray(new PAPEPartition[0])};
        return partitions;
    }

    public void resetProperties(boolean partitioned) throws Exception {
        IPANonRMI paNonRMI = this.m_node.getPANonRMI();
        PEEventLog[] logs = paNonRMI.getPEEventLogs();
        PAPEPartition[] partitions = paNonRMI.getPAPEPartitions();
        this.resetProperties(partitioned, logs, partitions);
    }

    public void resetProperties(boolean partitioned, PEEventLog[] logs, PAPEPartition[] partitions) throws Exception {
        EventLogNode eNode;
        EventLogRegionNode regionNode;
        int i;
        long timestamp = System.currentTimeMillis();
        super.setEnabled(partitioned);
        if (!partitioned) {
            this.removeAll();
            this.m_layoutInitialized = false;
            this.setCommittedPartitions(null);
            return;
        }
        if (!this.m_layoutInitialized) {
            this.initLayout();
        }
        Enumeration<TreeNode> i2 = this.m_root.depthFirstEnumeration();
        while (i2.hasMoreElements()) {
            EventLogBaseNode node = (EventLogBaseNode)i2.nextElement();
            node.initSelected(false);
        }
        for (i = 0; i < partitions.length; ++i) {
            PAPEPartition p = partitions[i];
            regionNode = this.m_root.getRegionNode(p.getRegionId());
            if (regionNode == null) {
                regionNode = new EventLogRegionNode(p.getRegionId());
                this.m_root.add(regionNode);
            }
            regionNode.initSelected(true);
            regionNode.setRefreshTimestamp(timestamp);
            eNode = regionNode.getEventLogNode(p.getEventLog());
            if (eNode == null) {
                eNode = new EventLogNode(p);
                regionNode.add(eNode);
            }
            eNode.initSelected(true);
            eNode.setRefreshTimestamp(timestamp);
        }
        for (i = 0; i < logs.length; ++i) {
            PEEventLog log = logs[i];
            regionNode = this.m_root.getRegionNode(log.getRegion());
            if (regionNode == null) {
                regionNode = new EventLogRegionNode(log.getRegion());
                this.m_root.add(regionNode);
            }
            regionNode.setRefreshTimestamp(timestamp);
            eNode = regionNode.getEventLogNode(log.getName());
            if (eNode == null) {
                eNode = new EventLogNode(new PAPEPartition(log.getRegion(), log.getName()));
                regionNode.add(eNode);
            }
            if (regionNode.getAllEventLogNode().isSelected()) {
                eNode.initSelected(true);
            }
            eNode.setRefreshTimestamp(timestamp);
        }
        Enumeration<TreeNode> e = this.m_root.children();
        while (e.hasMoreElements()) {
            EventLogRegionNode regionNode2 = (EventLogRegionNode)e.nextElement();
            if (regionNode2.getRefreshTimestamp() != timestamp) {
                ((DefaultTreeModel)this.m_tree.getModel()).removeNodeFromParent(regionNode2);
                continue;
            }
            Enumeration<TreeNode> j = regionNode2.children();
            while (j.hasMoreElements()) {
                eNode = (EventLogNode)j.nextElement();
                if (eNode.getRefreshTimestamp() == timestamp || eNode.isAllEventLog()) continue;
                ((DefaultTreeModel)this.m_tree.getModel()).removeNodeFromParent(eNode);
            }
        }
        this.setCommittedPartitions(partitions);
        ((DefaultTreeModel)this.m_tree.getModel()).nodeChanged(this.m_root);
    }

    private void setCommittedPartitions(PAPEPartition[] partitions) {
        this.m_committedPartitions.clear();
        if (partitions != null) {
            for (int i = 0; i < partitions.length; ++i) {
                Integer region = new Integer(partitions[i].getRegionId());
                HashMap<String, PAPEPartition> partitionMap = (HashMap<String, PAPEPartition>)this.m_committedPartitions.get(region);
                if (partitionMap == null) {
                    partitionMap = new HashMap<String, PAPEPartition>();
                    this.m_committedPartitions.put(region, partitionMap);
                }
                partitionMap.put(partitions[i].getEventLog(), partitions[i]);
            }
        }
    }

    private boolean isPartitionCommitted(PAPEPartition p) {
        HashMap partitionMap = this.getCommittedPartitionMap(p.getRegionId());
        return partitionMap != null && partitionMap.containsKey(p.getEventLog());
    }

    protected HashMap getCommittedPartitionMap(int region) {
        return (HashMap)this.m_committedPartitions.get(new Integer(region));
    }

    public void validateTextFields() throws VWException {
        Enumeration<TreeNode> i = this.m_root.children();
        while (i.hasMoreElements()) {
            EventLogRegionNode region = (EventLogRegionNode)i.nextElement();
            if (!region.isSelected()) continue;
            boolean logSelected = false;
            Enumeration<TreeNode> j = region.children();
            while (j.hasMoreElements()) {
                EventLogNode log = (EventLogNode)j.nextElement();
                if (!log.isSelected()) continue;
                logSelected = true;
            }
            if (logSelected) continue;
            throw new VWException("filenet.vw.apps.taskman.pa.eventlog.EventLogConfigPanel.AtLeastOneEventLogMustBeSelected", "At least one event log must be selected for region {0}.", new Integer(region.getRegion()));
        }
    }

    public EventLogRootNode getRoot() {
        return this.m_root;
    }

    public EventLogTree getTree() {
        return this.m_tree;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_tree != null) {
            this.m_tree.setEnabled(enabled);
            this.m_tree.setEditable(enabled);
        }
    }

    private void logPartitionArray(PAPEPartition[] arr, String heading) {
        String method = "logPartitionArray";
        if (arr == null || arr.length == 0) {
            return;
        }
        this.m_logger.fine(this.m_className, method, heading);
        for (int i = 0; i < arr.length; ++i) {
            PAPEPartition p = arr[i];
            this.m_logger.fine(this.m_className, method, "Region: " + p.getRegionId() + ", Log: " + p.getEventLog());
        }
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JScrollPane(this.m_tree), c);
        this.revalidate();
        this.repaint();
        this.m_layoutInitialized = true;
    }
}

